 ; Ŀ
 ;   Stote - write all text and attribute strings to a file, one string    
 ;   per line, but attributes from a single block are all on one comma     
 ;   separated line, add the filename every 20 lines.                      
 ;   Copyright 1991, 1995, 2003, 2009 by Rocket Software Ltd.              
 ;   There is no red dishwashing liquid.                                   
 ; 

 ; Ŀ
 ;   Riot - write text to a file if it isn't an empty string.              
 ;   Arguments: Txt, the string to write to the file.                      
 ;              Filnam, the file handle.                                   
 ;              Endp, if t then don't add a file name line.                
 ;   Calls nothing, Returns nothing.                                       
 ;   The variables steps and namstr must be global.                        
 ; 
 (DEFUN RIOT (txt filnam endp)
  (while (and (> (strlen txt) 0) (= (substr txt 1 1) " "))
         (setq txt (substr txt 2)))
  (if (not (member txt '("" " ")))
      (progn
           (write-line txt filnam)
           (if (> (setq steps (1+ steps)) 20)
               (progn
                    (setq steps 1)
                    (if (null endp) (write-line namstr filnam))))))
 (princ))
 ; Ŀ
 ;   Riot end.                                                             
 ; 

 ; Ŀ
 ;   Fruge - see if a file name exists and decide what to do with it.      
 ; 
 (DEFUN FRUGE (/ filp filnam quipt subfil)
  (setq filp (getvar "dwgname"))
  (if (= (substr (strcase filp) (- (strlen filp) 3)) ".DWG")
      (setq filp (substr filp 1 (- (strlen filp) 4))))
  (setq filp (strcat filp ".lis"))
  (setq filnam (getstring (strcat "\nFilename <" filp ">: ")))
  (if (= filnam "") (setq filnam filp))
  (if (findfile filnam)
      (progn
           (initget 0 "Overwrite Append Quit")
           (setq quipt (getkword (strcat "That file already exists."
                                         "  Overwrite, Append, or <Quit>? ")))
           (if (null quipt) (setq quipt "Quit"))))
  (cond ((or (null quipt) (= quipt "Append"))
         (setq subfil (open filnam "a"))
         (if (null subfil)
             (write-line "Unable to open that file")))
        ((= quipt "Overwrite")
         (setq subfil (open filnam "w"))
         (close subfil)
         (setq subfil (open filnam "a"))
         (if (null subfil)
             (write-line "Unable to open that file")))
        ((= quipt "Quit")
         (setq subfil ())))
 subfil)
 ; Ŀ
 ;   Fruge end.                                                            
 ; 

 ; Ŀ
 ;   Stote - the predator.                                                 
 ; 
 (DEFUN C:STOTE (/ getinv filnam dnam namstr prefx ss lenx numtx so txt endp
                     steps txa num entt sub invis len visatt enam esub nxtxt)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Initialise the repeated file name inserter.                           
 ; 
  (setq steps 1)
 ; Ŀ
 ;   Get various preferences - what to include and a filename.             
 ;   (Unless we are in the middle of a script.)                            
 ; 
  (if (/= 4 (logand 4 (getvar "cmdactive")))
      (progn
           (initget 0 "Yes No")
           (setq getinv (getkword "Include invisible attributes? <No>: "))
           (if (= getinv "Yes")
               (setq getinv T)
               (setq getinv ()))
           (setq filnam (fruge)))
      (progn
           (setq getinv ())
           (setq filnam (open "c:\\alltext.txt" "a"))))
 ; Ŀ
 ;   Write the drawing file name to the text file.                         
 ; 
  (setq dnam (getvar "dwgname"))
  (setq prefx (getvar "dwgprefix"))
  (riot (strcat "***** Start " dnam " *****  (" prefx dnam ")") filnam endp)
  (setq namstr (strcat "***** " dnam " *****  (" prefx dnam ")"))
 ; Ŀ
 ;   Get a selection set of all text entities.                             
 ; 
  (setq ss (ssget "X" '((0 . "TEXT"))))
 ; Ŀ
 ;   Make a length counter half-string.                                    
 ; 
  (if ss (setq lenx (strcat "/" (itoa (sslength ss))))
         (prompt "No text found."))
 ; Ŀ
 ;   While there are text entities in the selection set.                   
 ; 
  (setq numtx 0)
  (while (and ss (setq so (ssname ss numtx)))
         (setq txt (cdr (assoc 1 (setq txa (entget so)))))
         (riot txt filnam endp)
         (grtext -2 (strcat (itoa (setq numtx (1+ numtx))) lenx)))
 ; Ŀ
 ;   Get a selection set of all mtext entities.                            
 ; 
  (setq ss (ssget "X" '((0 . "mtext"))))
 ; Ŀ
 ;   Make a length counter half-string.                                    
 ; 
  (if ss (setq lenx (strcat "/" (itoa (sslength ss))))
         (prompt "No mtext found."))
 ; Ŀ
 ;   While there are mtext entities in the selection set.                  
 ; 
  (setq num 0)
  (while (and ss (setq so (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget so))
         (while (setq sub (car entt))
                (setq entt (cdr entt))
                (if (member (car sub) '(1 3))
                    (riot (cdr sub) filnam endp)))
         (grtext -2 (strcat (itoa (setq numtx (1+ numtx))) lenx)))
 ; Ŀ
 ;   Now repeat for attributes.                                            
 ; 
  (setq num 0)    ; position in ss
  (setq invis 0)  ; invisible attribute counter
 ; Ŀ
 ;   Get a selection set of blocks with attributes.                        
 ; 
  (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
 ; Ŀ
 ;   Make a length counter half-string.                                    
 ; 
  (if ss
     (setq len (strcat "/" (itoa (sslength ss))))
     (prompt "No attributed blocks found."))
 ; Ŀ
 ;   While there are blocks in the ss, process them.                       
 ; 
  (setq visatt 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq esub (entnext enam))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq txt "")
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub)))))
                (setq nxtxt (cdr (assoc 1 entt)))
                (if (= 1 (logand 1 (cdr (assoc 70 entt))))  ; invisible?
                    (progn
                         (setq invis (1+ invis))
                         (if getinv
                            (setq txt (strcat txt
                                              (if (= txt "") "" ",")
                                              nxtxt))))
                    (progn
                         (setq visatt (1+ visatt))
                         (setq txt (strcat txt
                                           (if (= txt "") "" ",")
                                           nxtxt))))
                (setq esub (entnext esub)))
         (if txt (riot txt filnam endp)))
 ; Ŀ
 ;   Add a couple of empty lines, close the output file.                   
 ; 
  (riot (strcat "***** End of " (getvar "dwgname") " *****") filnam endp)
  (setq endp t)
  (riot "\n\n\n\n\n" filnam endp)
  (close filnam)
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (prompt (strcat "\nText: " (itoa numtx)
                  "; Attributes - Visible: " (itoa visatt)
                  ", Invisible: " (itoa invis)))
 (princ))